*****************************************************************
* Demo HoverContainer                                           *
*                                                               *
*  Gerrit J. Broekhuis                   last edit 01-10-2023  *
*****************************************************************

PUBLIC _maindesc, llHover, llHoverDelay, llHoverDelayCount 						&& public variables only for this demo
_maindesc 			= ""
llHover				= .T.														&& set hovering ON/OFF; in real life these values are read form a setup table
llHoverDelay 		= .T.														&& set multispeed autoscrolling ON/OFF
llHoverDelayCount 	= 10														&& number of records with delayed scrolling


ON KEY LABEL ALT+F4 do end_program
ON SHUTDOWN do end_program


DO FORM "maindesc.scx" NAME MAINDESC											&& NAME clause is required; otherwise the procedure KeyboardEnter cannot find the object | 09-07-2023
READ EVENTS


PROCEDURE end_program
CLEAR events
CLOSE all
QUIT
ENDPROC


*****************************************************************
* KeyboardEnter is being called by hovercontainer.mousenter     *
* when using the ENTER key, hovercontainer does not have a      *
* KeyPress event, therefore we guide ON KEY LABEL ENTER to      *
* Grid1.DblClick with Form.NAME as parameter. GridName is read  *
* from the form's hovercontainer.                               *
*                                                               *
*  Gerrit J. Broekhuis                   last edit 27-07-2023  *
*****************************************************************
PROCEDURE KeyboardEnter
PARAMETERS cForm
LOCAL lcGridName
lcGridName = &cForm..hovercontainer1.GridName
&& WAIT WINDOW "Form     = " + TRANSFORM(cForm)	
&& WAIT WINDOW "Gridname = " + lcGridName
TRY
	&cForm..&lcGridName..DblClick		
CATCH
	WAIT WINDOW "ENTER for form " + cForm + " is not possible!" timeout(1)
ENDTRY
ENDPROC


************************************************************
* Procedure that can be called with right mouse click      *
************************************************************
PROCEDURE STAM_MAINDESC
WAIT WINDOW "Right Mouse click detected!" timeout(2)
ENDPROC




























































